<?= $this->extend('backend/layout/template_admin'); ?>


<?= $this->section('content'); ?>


<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
      <div class="breadcrumb-title pe-3">Settting</div>
      <div class="ps-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0 p-0">
            <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Setting</li>
          </ol>
        </nav>
      </div>

    </div>
    <!--end breadcrumb-->
    <div class="container">
      <div class="main-body">
        <div class="row">

          <div class="col-lg-12">
            <div class="card">
              <div class="card-body">
                <div class="row mb-3">
                  <form method="post" action="" id="datasekolahform" enctype="multipart/form-data">
                    <input type="hidden" class="form-control" value="<?= $setting['id']; ?>" name="id" />
                    <div class="col-12">
                      <h6><label for="nama_sekolah" class="form-label">Nama Sekolah / Organisasi</label></h6>
                      <input type="text" class="form-control" value="<?= $setting['nama_sekolah']; ?>" name="nama_sekolah" />
                    </div>

                </div>
                <div class="row mb-3">

                  <div class="col-6">
                    <h6><label for="tahun_ajaran" class="form-label">Tahun Ajaran</label></h6>
                    <input type="text" class="form-control" value="<?= $setting['tahun_ajaran']; ?>" name="tahun_ajaran" />
                  </div>
                  <div class="col-6">
                    <h6><label for="tgl_buka" class="form-label">Tgl Buka</label></h6>
                    <input type="datetime-local" class="form-control" value="<?= date('Y-m-d\TH:i:s', strtotime($setting['tgl_buka'])); ?>" name="tgl_buka" />
                  </div>

                </div>


                <div class="row">
                  <div class="col-sm-3"></div>
                  <div class="col-sm-9 text-secondary">
                    <input type="submit" id="btnupdatedatasekolah" class="btn btn-primary px-4" value="Save Changes" />
                  </div>
                </div>
              </div>
            </div>
            </form>
          </div>

        </div>
      </div>
    </div>
  </div>
</div>
<!--end page wrapper -->

<script>
  $(document).ready(function() {
    // Update  Data Sekolah
    $("#datasekolahform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/setting/edit',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btnupdatedatasekolah').attr('disabled');
          $("#btnupdatedatasekolah").html(`<div class="spinner-border spinner-border-sm" role="status" aria-hidden="true"><span class="visually-hidden">Loading...</span></div>`);


        },
        success: function(data) {
          if (data.responce == "success") {
            // console.log(data.update);
            Swal.fire({
              position: 'center',
              icon: 'success',
              title: 'Data berhasil diupdate',
              showConfirmButton: false,
              timer: 2000
            })

            setTimeout(function() {
              /* show the alert for 3sec and then reload the page. */
              window.location.reload();
            }, 1500);

          } else {
            toastr["error"](data.pesan);
            // console.log(data);
          }

        },
        complete: function() {
          $('#btnupdatedatasekolah').removeAttr('disabled');
          $("#btnupdatedatasekolah").html(`Save Change`);

        },
      });


    });

  });
</script>
<?= $this->endSection(); ?>