<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col mb-3">
        <!-- Button trigger modal -->
        <button type="button" class="btn btn-primary" id="btntambahgolgajibaru" data-toggle="modal" data-target="#golgajiModal">
          Tambah Golongan
        </button>

        <!-- Modal -->
        <div class="modal fade" id="golgajiModal" tabindex="-1" aria-labelledby="golgajiModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="golgajiModalLabel">Tambah Golongan</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form method="post" action="" id="tambahgolgajiform">
                  <?= csrf_field(); ?>
                  <div class="form-group row">
                    <label for="golgaji" class="col-sm-2 col-form-label">Gol. Gaji</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="golgaji">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label for="sort" class="col-sm-2 col-form-label">Sort</label>
                    <div class="col-sm-2">
                      <input type="text" class="form-control" name="sort">
                    </div>
                  </div>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" id="btnsavegolgaji" class="btn btn-primary">Simpan</button>
              </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>


    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tableGolgaji">
            <thead class="bg-navy">
              <tr>
                <th scope="col">No</th>
                <th scope="col">Gol. Gaji</th>
                <th scope="col">Sort</th>
                <th scope="col">Action</th>
              </tr>
            </thead>

          </table>
        </div>


      </div>
    </div>

    <!-- Modal Edit -->
    <div class="modal fade" id="editgolgajiModal" tabindex="-1" aria-labelledby="editgolgajiModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editgolgajiModalLabel">Edit Golongan</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form method="post" action="" id="editgolgajiform">
              <?= csrf_field(); ?>
              <input type="hidden" class="form-control" name="idgolgaji">
              <input type="hidden" class="form-control" name="golgajilama">
              <div class="form-group row">
                <label for="golgaji" class="col-sm-2 col-form-label">Gol. Gaji</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="golgaji">
                </div>
              </div>

              <div class="form-group row">
                <label for="sort" class="col-sm-2 col-form-label">Sort</label>
                <div class="col-sm-2">
                  <input type="text" class="form-control" name="sort">
                </div>
              </div>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="btneditgolgaji" class="btn btn-primary">Update</button>
          </div>
          </form>
        </div>
      </div>
    </div>

  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->


<script>
  $(document).ready(function() {

    $("#btntambahgolgajibaru").click(function() {
      $('#tambahgolgajiform')[0].reset();
    });

    //fetch divisi
    function fetchGolgaji() {
      $.ajax({
        url: '<?= base_url(); ?>/datasekolah/fetchgolgaji',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          $('#tableGolgaji').DataTable({
            "data": data.gol_gaji,
            "responsive": true,
            "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": [{
                extend: 'copyHtml5',
                text: '<i class="far fa-fw fa-copy"></i>',
                titleAttr: 'Copy'
              },
              {
                extend: 'excelHtml5',
                text: '<i class="far fa-fw fa-file-excel"></i>',
                titleAttr: 'Excel'
              },
              {
                extend: 'pdfHtml5',
                text: '<i class="far fa-fw fa-file-pdf"></i>',
                titleAttr: 'Pdf'
              },
              {
                extend: 'print',
                text: '<i class="fas fa-fw fa-print"></i>',
                titleAttr: 'Print'
              }
            ],

            "columns": [{
                "data": null,
                "render": function() {
                  return a = i++;
                }
              },
              {
                "data": "gol_gaji"
              },
              {
                "data": "sort"
              },
              {
                "data": null,
                "render": function(data, type, row, meta) {
                  let a = '';

                  a = `
                                    <a href="" class="badge badge-info editgolgaji" value="${row.id}"><i class="far fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deletegolgaji"><i class="fas fa-fw fa-trash-alt"></i></a>`;


                  return a;
                }
              }
            ]
          });
        }
      });
    }

    fetchGolgaji();

    // save divisi
    $('#tambahgolgajiform').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/datasekolah/savegolgaji'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        // data: $(this).serialize(),
        beforeSend: function() {
          // setting a timeout
          $('#btnsavegolgaji').attr('disabled');
          $("#btnsavegolgaji").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#golgajiModal').modal('hide');
            $('#tableGolgaji').DataTable().destroy();

            fetchGolgaji();
            toastr["success"](data.pesan);

          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnsavegolgaji').removeAttr('disabled');
          $("#btnsavegolgaji").html(`Simpan`);

        },
      });
    });

    // delete golongan
    $(document).on("click", ".deletegolgaji", function() {
      event.preventDefault();
      let idgolgaji = $(this).attr('value');

      Swal.fire({
        title: 'Apa kamu yakin untuk menghapusnya?',
        text: "kamu tidak akan bisa mengembalikannya",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, hapus saja!'
      }).then((result) => {
        if (result.value) {
          $.ajax({
            url: '<?= base_url('/datasekolah/deletegolgaji'); ?>/' + idgolgaji,
            type: 'DELETE',
            error: function() {
              alert('Something is wrong');
            },
            success: function(data) {
              $('#tableGolgaji').DataTable().destroy();
              fetchGolgaji();
              Swal.fire(
                'Deleted!',
                'File sudah terdelete.',
                'success'
              )
            }
          });

        }
      })
    });

    // modal edit
    $(document).on("click", ".editgolgaji", function() {
      event.preventDefault();
      let idgolgaji = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/datasekolah/editgolgajimodal'); ?>',
        type: 'post',
        data: {
          idgolgaji: idgolgaji
        },
        dataType: 'json',
        success: function(data) {
          if (data.responce == 'success') {
            $('#editgolgajiModal').modal('show');
            $("input[name='idgolgaji']").val(data.gol_gaji.id);
            $("input[name='golgajilama']").val(data.gol_gaji.gol_gaji);
            $("input[name='golgaji']").val(data.gol_gaji.gol_gaji);
            $("input[name='sort']").val(data.gol_gaji.sort);
          } else {

            toastr["error"](data.pesan);
          }
        }
      });
    });

    // edit Divisi

    $("#editgolgajiform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/datasekolah/editgolgaji',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btneditgolgaji').attr('disabled');
          $("#btneditgolgaji").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          // console.log(data);
          if (data.responce == "success") {
            $('#editgolgajiModal').modal('hide');
            $('#tableGolgaji').DataTable().destroy();
            fetchGolgaji();
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btneditgolgaji').removeAttr('disabled');
          $("#btneditgolgaji").html(`Update`);

        },
      });


    });

  });
</script>

<?= $this->endSection(); ?>