<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col mb-3">
        <!-- Button trigger modal -->
        <button type="button" class="btn btn-primary" id="btntambahpangkatbaru" data-toggle="modal" data-target="#pangkatModal">
          Tambah Pangkat
        </button>

        <!-- Modal -->
        <div class="modal fade" id="pangkatModal" tabindex="-1" aria-labelledby="pangkatModalLabel" aria-hidden="true">
          <div class="modal-dialog  ">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="pangkatModalLabel">Tambah Pangkat</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form method="post" action="" id="tambahpangkatform">
                  <?= csrf_field(); ?>
                  <div class="form-group row">
                    <label for="golongan" class="col-sm-2 col-form-label">Golongan</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="golongan">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label for="pangkat" class="col-sm-2 col-form-label">Pangkat</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="pangkat">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label for="waktu" class="col-sm-2 col-form-label">Waktu Pencapaian(tahun)</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="waktu">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label for="nilai" class="col-sm-2 col-form-label">Nilai Minimal</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="nilai">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="tahun_terakhir" class="col-sm-2 col-form-label">Tahun Nilai Min</label>
                    <div class="col-sm-10">
                      <input type="text" class="form-control" name="tahun_terakhir">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label for="sort" class="col-sm-2 col-form-label">Urutan</label>
                    <div class="col-sm-2">
                      <input type="text" class="form-control" name="sort">
                    </div>
                  </div>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" id="btnsavepangkat" class="btn btn-primary">Simpan</button>
              </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>


    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tablePangkat">
            <thead class="bg-navy">
              <tr>
                <th scope="col">No</th>
                <th scope="col">Golongan</th>
                <th scope="col">Pangkat</th>
                <th scope="col">Waktu Pencapaian(tahun)</th>
                <th scope="col">Nilai Minimal</th>
                <th scope="col">Tahun Nilai Min</th>
                <th scope="col">Urutan</th>
                <th scope="col">Action</th>
              </tr>
            </thead>

          </table>
        </div>


      </div>
    </div>

    <!-- Modal Edit -->
    <div class="modal fade" id="editpangkatModal" tabindex="-1" aria-labelledby="editpangkatModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editpangkatModalLabel">Edit Pangkat</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form method="post" action="" id="editpangkatform">
              <?= csrf_field(); ?>
              <input type="hidden" class="form-control" name="idpangkat">
              <!-- <input type="hidden" class="form-control" name="golgajilama"> -->
              <div class="form-group row">
                <label for="golongan" class="col-sm-2 col-form-label">Golongan</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="golongan">
                </div>
              </div>

              <div class="form-group row">
                <label for="pangkat" class="col-sm-2 col-form-label">Pangkat</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="pangkat">
                </div>
              </div>

              <div class="form-group row">
                <label for="waktu" class="col-sm-2 col-form-label">Waktu Pencapaian(tahun)</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="waktu">
                </div>
              </div>
              <div class="form-group row">
                <label for="nilai" class="col-sm-2 col-form-label">Nilai Minimal</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="nilai">
                </div>
              </div>

              <div class="form-group row">
                <label for="tahun_terakhir" class="col-sm-2 col-form-label">Tahun Nilai Min</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" name="tahun_terakhir">
                </div>
              </div>

              <div class="form-group row">
                <label for="sort" class="col-sm-2 col-form-label">Urutan</label>
                <div class="col-sm-2">
                  <input type="text" class="form-control" name="sort">
                </div>
              </div>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="btneditpangkat" class="btn btn-primary">Update</button>
          </div>
          </form>
        </div>
      </div>
    </div>

  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->


<script>
  $(document).ready(function() {

    $("#btntambahpangkatbaru").click(function() {
      $('#tambahpangkatform')[0].reset();
    });

    //fetch divisi
    function fetchPangkat() {
      $.ajax({
        url: '<?= base_url(); ?>/datasekolah/fetchpangkat',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          $('#tablePangkat').DataTable({
            "data": data.pangkat,
            "responsive": true,
            "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": [{
                extend: 'copyHtml5',
                text: '<i class="far fa-fw fa-copy"></i>',
                titleAttr: 'Copy'
              },
              {
                extend: 'excelHtml5',
                text: '<i class="far fa-fw fa-file-excel"></i>',
                titleAttr: 'Excel'
              },
              {
                extend: 'pdfHtml5',
                text: '<i class="far fa-fw fa-file-pdf"></i>',
                titleAttr: 'Pdf'
              },
              {
                extend: 'print',
                text: '<i class="fas fa-fw fa-print"></i>',
                titleAttr: 'Print'
              }
            ],

            "columns": [{
                "data": null,
                "render": function() {
                  return a = i++;
                }
              },
              {
                "data": "golongan"
              },
              {
                "data": "pangkat"
              },
              {
                "data": "waktu"
              },
              {
                "data": null,
                "render": function(data, type, row, meta) {
                  let b = row.nilai.toUpperCase();
                  return b;
                }
              },
              {
                "data": "tahun_terakhir"
              },
              {
                "data": "sort"
              },
              {
                "data": null,
                "render": function(data, type, row, meta) {
                  let a = '';

                  a = `
                                    <a href="" class="badge badge-info editpangkat" value="${row.id}"><i class="far fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deletepangkat"><i class="fas fa-fw fa-trash-alt"></i></a>`;
                  return a;
                }
              }
            ]
          });
        }
      });
    }

    fetchPangkat();

    // save divisi
    $('#tambahpangkatform').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/datasekolah/savepangkat'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        // data: $(this).serialize(),
        beforeSend: function() {
          // setting a timeout
          $('#btnsavepangkat').attr('disabled');
          $("#btnsavepangkat").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#pangkatModal').modal('hide');
            $('#tablePangkat').DataTable().destroy();

            fetchPangkat();
            toastr["success"](data.pesan);

          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnsavepangkat').removeAttr('disabled');
          $("#btnsavepangkat").html(`Simpan`);

        },
      });
    });

    // delete golongan
    $(document).on("click", ".deletepangkat", function() {
      event.preventDefault();
      let idpangkat = $(this).attr('value');

      Swal.fire({
        title: 'Apa kamu yakin untuk menghapusnya?',
        text: "kamu tidak akan bisa mengembalikannya",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, hapus saja!'
      }).then((result) => {
        if (result.value) {
          $.ajax({
            url: '<?= base_url('/datasekolah/deletepangkat'); ?>/' + idpangkat,
            type: 'DELETE',
            error: function() {
              alert('Something is wrong');
            },
            success: function(data) {
              $('#tablePangkat').DataTable().destroy();
              fetchPangkat();
              Swal.fire(
                'Deleted!',
                'File sudah terdelete.',
                'success'
              )
            }
          });

        }
      })
    });

    // modal edit
    $(document).on("click", ".editpangkat", function() {
      event.preventDefault();
      let idpangkat = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/datasekolah/editpangkatmodal'); ?>',
        type: 'post',
        data: {
          idpangkat: idpangkat
        },
        dataType: 'json',
        success: function(data) {
          if (data.responce == 'success') {
            $('#editpangkatModal').modal('show');
            $("input[name='idpangkat']").val(data.pangkat.id);
            // $("input[name='golgajilama']").val(data.gol_gaji.gol_gaji);
            $("input[name='golongan']").val(data.pangkat.golongan);
            $("input[name='pangkat']").val(data.pangkat.pangkat);
            $("input[name='waktu']").val(data.pangkat.waktu);
            $("input[name='nilai']").val(data.pangkat.nilai);
            $("input[name='tahun_terakhir']").val(data.pangkat.tahun_terakhir);
            $("input[name='sort']").val(data.pangkat.sort);
          } else {

            toastr["error"](data.pesan);
          }
        }
      });
    });

    // edit Divisi

    $("#editpangkatform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/datasekolah/editpangkat',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btneditpangkat').attr('disabled');
          $("#btneditpangkat").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          // console.log(data);
          if (data.responce == "success") {
            $('#editpangkatModal').modal('hide');
            $('#tablePangkat').DataTable().destroy();
            fetchPangkat();
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btneditpangkat').removeAttr('disabled');
          $("#btneditpangkat").html(`Update`);

        },
      });


    });

  });
</script>

<?= $this->endSection(); ?>