<?php

namespace App\Controllers\backend;


use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\UserModel;
use App\Models\TglbukaModel;
use App\Models\AlurModel;
use App\Models\BiayaModel;
use CodeIgniter\Controller;


class Biaya extends Controller
{

  protected $loginModel;
  protected $capesModel;
  protected $userModel;
  protected $tglBukaModel;
  protected $alurModel;
  protected $biayaModel;


  public function __construct()
  {
    $this->loginModel = new LoginModel();
    $this->capesModel = new CapesModel();
    $this->userModel = new UserModel();
    $this->tglBukaModel = new TglbukaModel();
    $this->alurModel = new AlurModel();
    $this->biayaModel = new BiayaModel();
  }

  public function index()
  {
    $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

    // dd($submenu);

    $data = [
      'title' => 'Biaya PPDB',
      'user' => $cekuser

    ];

    return view('backend/biaya', $data);
  }

  public function fetchbiaya()
  {
    if ($this->request->isAJAX()) {
      if ($biaya = $this->biayaModel->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'biaya' => $biaya
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch biaya'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function tambahbiaya()
  {
    if ($this->request->isAJAX()) {

      if (!$this->validate([
        'foto' => [
          'rules' => 'max_size[foto,10240]|is_image[foto]|mime_in[foto,image/jpg,image/jpeg,image/png]',
          'errors' => [

            'max_size' => 'ukuran gambar terlalu besar. Max 10 mb ',
            'is_image' => 'foto yang anda pilih bukan gambar',
            'mime_in' => 'Gunakan file ekstensi jpg/jpeg/png'
          ]
        ],
        'sort' => [
          'rules' => 'required|numeric',
          'errors' => [
            'required' => 'Sort tidak boleh kosong',
            'numeric' => 'sort harus berupa angka'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();

        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses
        $fileFoto = $this->request->getFile('foto');

        if ($this->request->getVar('aktif') == null) {
          $active = 0;
        } else {
          $active = 1;
        }

        //generate nama file random
        $namaFoto = $fileFoto->getRandomName();

        $insert = [
          'biaya' => $namaFoto,
          'sort' => $this->request->getVar('sort'),
          'aktif' => $active,
        ];

        if ($this->biayaModel->insert($insert)) {
          //pindahkan gambar
          $fileFoto->move('asset/images/biaya', $namaFoto);
        };

        $data = [
          'responce' => 'success',
          'pesan' => 'Data Biaya berhasil ditambah',
        ];
      }
      echo json_encode($data);
    } else {
      echo "No Direct Script access allowed";
    }
  }

  public function deletebiaya($id)
  {
    if ($this->request->isAJAX()) {

      if ($biaya = $this->biayaModel->where('id', $id)->get()->getRowArray()) {
        unlink('asset/images/biaya/' . $biaya['biaya']);
      }

      $this->biayaModel->where('id', $id)->delete();
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editbiayamodal()
  {
    if ($this->request->isAJAX()) {
      $idbiaya = $this->request->getVar('idbiaya');
      if ($biaya = $this->biayaModel->where('id', $idbiaya)->get()->getRowArray()) {
        $data = [
          'responce' => 'success',
          'biaya' => $biaya
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal memunculkan modal edit data'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editbiaya()
  {
    if ($this->request->isAJAX()) {
      if (!$this->validate([
        'sort' => [
          'rules' => 'required',
          'errors' => [
            'required' => 'Sort tidak boleh kosong'
          ]
        ]
      ])) {
        $validation = \Config\Services::validation();

        $data = [
          'responce' => 'error',
          'pesan' => $validation->listErrors()
        ];
      } else {
        // validasi sukses
        $idbiaya = $this->request->getVar('idbiaya');
        $sort = $this->request->getVar('sort');

        if ($this->request->getVar('aktif') == null) {
          $active = 0;
        } else {
          $active = 1;
        }

        $update = [
          'sort' => $sort,
          'aktif' => $active
        ];

        $this->biayaModel->update($idbiaya, $update);

        $data = [
          'responce' => 'success',
          'pesan' => 'Biaya berhasil diupdate',

        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }
}
