<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
  require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/**
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');
$routes->get('/peserta', 'Home::peserta');
$routes->get('/home/peserta', 'Home::peserta');
$routes->post('/fetchcapesfront', 'Home::fetchcapesfront');
$routes->post('/home/fetchcapesfront', 'Home::fetchcapesfront');
$routes->get('/registrasi', 'Home::registrasi');
$routes->get('/home/registrasi', 'Home::registrasi');
$routes->get('/pagelogin', 'Home::pagelogin');
$routes->get('/home/pagelogin', 'Home::pagelogin');
$routes->get('/prosedur', 'Home::prosedur');
$routes->get('/home/prosedur', 'Home::prosedur');
$routes->get('/jadwalppdb/(:any)', 'Home::jadwalppdb/$1');
$routes->get('/home/jadwalppdb/(:any)', 'Home::jadwalppdb/$1');
$routes->get('/biayappdb', 'Home::biayappdb');
$routes->get('/home/biayappdb', 'Home::biayappdb');
$routes->get('/uploadberkas', 'Home::uploadberkas');
$routes->get('/home/uploadberkas', 'Home::uploadberkas');
$routes->post('/ceknamaupload', 'Home::ceknamaupload');
$routes->post('/home/ceknamaupload', 'Home::ceknamaupload');
$routes->post('/uploaddataberkas', 'Home::uploaddataberkas');
$routes->post('/home/uploaddataberkas', 'Home::uploaddataberkas');
$routes->get('/downloadberkas', 'Home::downloadberkas');
$routes->get('/home/downloadberkas', 'Home::downloadberkas');

// $routes->get('/kelastersedia', 'backend/Kelas::index');
$routes->get('/kelas', 'backend/Kelas::index', ['filter' => 'akseslogin']);
$routes->get('/backend/kelas', 'backend/Kelas::index', ['filter' => 'akseslogin']);
$routes->post('/kelas/fetchkelas', 'backend/Kelas::fetchkelas', ['filter' => 'akseslogin']);
$routes->post('/backend/kelas/fetchkelas', 'backend/Kelas::fetchkelas', ['filter' => 'akseslogin']);
$routes->post('/kelas/editkelasmodal', 'backend/Kelas::editkelasmodal', ['filter' => 'akseslogin']);
$routes->post('/backend/kelas/editkelasmodal', 'backend/Kelas::editkelasmodal', ['filter' => 'akseslogin']);
$routes->post('/kelas/editkelas', 'backend/Kelas::editkelas', ['filter' => 'akseslogin']);
$routes->post('/backend/kelas/editkelas', 'backend/Kelas::editkelas', ['filter' => 'akseslogin']);
$routes->post('/kelas/fetchkelasdivisi', 'backend/Kelas::fetchkelasdivisi', ['filter' => 'akseslogin']);
$routes->post('/backend/kelas/fetchkelasdivisi', 'backend/Kelas::fetchkelasdivisi', ['filter' => 'akseslogin']);



$routes->get('/login', 'Login::index');
$routes->post('/ceklogin', 'Login::ceklogin');
$routes->get('/logout', 'Login::logout');
$routes->get('/login/logout', 'Login::logout');

$routes->get('/admin', 'backend/Dashboard::index', ['filter' => 'akseslogin']);
$routes->get('/backend/admin', 'backend/Dashboard::index', ['filter' => 'akseslogin']);

$routes->get('/capes', 'backend/Capes::index', ['filter' => 'akseslogin']);
$routes->get('/backend/capes', 'backend/Capes::index', ['filter' => 'akseslogin']);
$routes->post('/capes/fetchcapessemua', 'backend/Capes::fetchcapessemua', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/fetchcapessemua', 'backend/Capes::fetchcapessemua', ['filter' => 'akseslogin']);
$routes->post('/capes/fetchcapesbelum', 'backend/Capes::fetchcapesbelum', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/fetchcapesbelum', 'backend/Capes::fetchcapesbelum', ['filter' => 'akseslogin']);
$routes->post('/capes/fetchcapessudah', 'backend/Capes::fetchcapessudah', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/fetchcapessudah', 'backend/Capes::fetchcapessudah', ['filter' => 'akseslogin']);
$routes->post('/capes/editmodal', 'backend/Capes::editmodal', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/editmodal', 'backend/Capes::editmodal', ['filter' => 'akseslogin']);
$routes->post('/capes/editcapes', 'backend/Capes::editcapes', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/editcapes', 'backend/Capes::editcapes', ['filter' => 'akseslogin']);
$routes->post('/capes/importcapes', 'backend/Capes::importcapes', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/importcapes', 'backend/Capes::importcapes', ['filter' => 'akseslogin']);
$routes->post('/capes/deletecapes', 'backend/Capes::deletecapes', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/deletecapes', 'backend/Capes::deletecapes', ['filter' => 'akseslogin']);
$routes->post('/capes/importva', 'backend/Capes::importva', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/importva', 'backend/Capes::importva', ['filter' => 'akseslogin']);
$routes->post('/capes/importstatus', 'backend/Capes::importstatus', ['filter' => 'akseslogin']);
$routes->post('/backend/capes/importstatus', 'backend/Capes::importstatus', ['filter' => 'akseslogin']);

$routes->post('/capes/tampilkelas', 'backend/Capes::tampilkelas');
$routes->post('/backend/capes/tampilkelas', 'backend/Capes::tampilkelas');
$routes->post('/capes/savecapes', 'backend/Capes::savecapes');
$routes->post('/backend/capes/savecapes', 'backend/Capes::savecapes');
$routes->get('/capes/cekstatuscapes', 'backend/Capes::cekstatuscapes');
$routes->get('/backend/capes/cekstatuscapes', 'backend/Capes::cekstatuscapes');

$routes->get('/berkas', 'backend/Berkas::index', ['filter' => 'akseslogin']);
$routes->get('/backend/berkas', 'backend/Berkas::index', ['filter' => 'akseslogin']);
$routes->post('/berkas/fetchberkassemua', 'backend/Berkas::fetchberkassemua', ['filter' => 'akseslogin']);
$routes->post('/backend/berkas/fetchberkassemua', 'backend/Berkas::fetchberkassemua', ['filter' => 'akseslogin']);
$routes->post('/berkas/fetchberkasdivisi', 'backend/Berkas::fetchberkasdivisi', ['filter' => 'akseslogin']);
$routes->post('/backend/berkas/fetchberkasdivisi', 'backend/Berkas::fetchberkasdivisi', ['filter' => 'akseslogin']);
$routes->delete('/berkas/deleteberkas/(:num)', 'backend\Berkas::deleteberkas/$1', ['filter' => 'akseslogin']);
$routes->delete('/backend/berkas/deleteberkas/(:num)', 'backend\Berkas::deleteberkas/$1', ['filter' => 'akseslogin']);

$routes->get('/berkas/filedownload', 'backend/Berkas::filedownload', ['filter' => 'akseslogin']);
$routes->get('/backend/berkas/filedownload', 'backend/Berkas::filedownload', ['filter' => 'akseslogin']);
$routes->post('/berkas/fetchdownload', 'backend/Berkas::fetchdownload', ['filter' => 'akseslogin']);
$routes->post('/backend/berkas/fetchdownload', 'backend/Berkas::fetchdownload', ['filter' => 'akseslogin']);
$routes->post('/berkas/savedownload', 'backend/Berkas::savedownload', ['filter' => 'akseslogin']);
$routes->post('/backend/berkas/savedownload', 'backend/Berkas::savedownload', ['filter' => 'akseslogin']);
$routes->post('/berkas/editdownloadmodal', 'backend/Berkas::editdownloadmodal', ['filter' => 'akseslogin']);
$routes->post('/backend/berkas/editdownloadmodal', 'backend/Berkas::editdownloadmodal', ['filter' => 'akseslogin']);
$routes->post('/berkas/editdownload', 'backend/Berkas::editdownload', ['filter' => 'akseslogin']);
$routes->post('/backend/berkas/editdownload', 'backend/Berkas::editdownload', ['filter' => 'akseslogin']);
$routes->delete('/berkas/deletedownload/(:num)', 'backend\Berkas::deletedownload/$1', ['filter' => 'akseslogin']);
$routes->delete('/backend/berkas/deletedownload/(:num)', 'backend\Berkas::deletedownload/$1', ['filter' => 'akseslogin']);

$routes->get('/user', 'backend/User::index', ['filter' => 'akseslogin']);
$routes->get('/backend/user', 'backend/User::index', ['filter' => 'akseslogin']);
$routes->post('/user/fetchuser', 'backend/User::fetchuser', ['filter' => 'akseslogin']);
$routes->post('/backend/user/fetchuser', 'backend/User::fetchuser', ['filter' => 'akseslogin']);
$routes->post('/user/saveuser', 'backend/User::saveuser', ['filter' => 'akseslogin']);
$routes->post('/backend/user/saveuser', 'backend/User::saveuser', ['filter' => 'akseslogin']);
$routes->post('/user/editmodal', 'backend/User::editmodal', ['filter' => 'akseslogin']);
$routes->post('/backend/user/editmodal', 'backend/User::editmodal', ['filter' => 'akseslogin']);
$routes->post('/user/edituser', 'backend/User::edituser', ['filter' => 'akseslogin']);
$routes->post('/backend/user/edituser', 'backend/User::edituser', ['filter' => 'akseslogin']);
$routes->post('/user/editprofil', 'backend/User::editprofil', ['filter' => 'akseslogin']);
$routes->post('/backend/user/editprofil', 'backend/User::editprofil', ['filter' => 'akseslogin']);
$routes->post('/user/editpassword', 'backend/User::editpassword', ['filter' => 'akseslogin']);
$routes->post('/backend/user/editpassword', 'backend/User::editpassword', ['filter' => 'akseslogin']);
$routes->delete('/user/deleteuser/(:num)', 'backend\User::deleteuser/$1', ['filter' => 'akseslogin']);
$routes->delete('/backend/user/deleteuser/(:num)', 'backend\User::deleteuser/$1', ['filter' => 'akseslogin']);

$routes->get('/profiluser', 'backend/ProfilUser::index', ['filter' => 'akseslogin']);
$routes->get('/backend/profiluser', 'backend/ProfilUser::index', ['filter' => 'akseslogin']);

$routes->get('/setting/tanggal', 'backend/Setting::tanggal', ['filter' => 'akseslogin']);
$routes->get('/backend/setting/tanggal', 'backend/Setting::tanggal', ['filter' => 'akseslogin']);
$routes->post('/setting/edittanggal', 'backend/Setting::edittanggal', ['filter' => 'akseslogin']);
$routes->post('/backend/setting/edittanggal', 'backend/Setting::edittanggal', ['filter' => 'akseslogin']);
$routes->get('/setting/alur', 'backend/Setting::alur', ['filter' => 'akseslogin']);
$routes->get('/backend/setting/alur', 'backend/Setting::alur', ['filter' => 'akseslogin']);
$routes->post('/setting/fetchalur', 'backend/Setting::fetchalur', ['filter' => 'akseslogin']);
$routes->post('/backend/setting/fetchalur', 'backend/Setting::fetchalur', ['filter' => 'akseslogin']);
$routes->post('/setting/tambahalur', 'backend/Setting::tambahalur', ['filter' => 'akseslogin']);
$routes->post('/backend/setting/tambahalur', 'backend/Setting::tambahalur', ['filter' => 'akseslogin']);
$routes->delete('/setting/deletealur/(:num)', 'backend\Setting::deletealur/$1', ['filter' => 'akseslogin']);
$routes->delete('/backend/setting/deletealur/(:num)', 'backend\Setting::deletealur/$1', ['filter' => 'akseslogin']);
$routes->post('/setting/editalurmodal', 'backend/Setting::editalurmodal', ['filter' => 'akseslogin']);
$routes->post('/backend/setting/editalurmodal', 'backend/Setting::editalurmodal', ['filter' => 'akseslogin']);
$routes->post('/setting/editalur', 'backend/Setting::editalur', ['filter' => 'akseslogin']);
$routes->post('/backend/setting/editalur', 'backend/Setting::editalur', ['filter' => 'akseslogin']);


$routes->get('/jadwal', 'backend/Jadwal::index', ['filter' => 'akseslogin']);
$routes->get('/backend/jadwal', 'backend/Jadwal::index', ['filter' => 'akseslogin']);
$routes->post('/jadwal/fetchjadwalsemua', 'backend/Jadwal::fetchjadwalsemua', ['filter' => 'akseslogin']);
$routes->post('/backend/jadwal/fetchjadwalsemua', 'backend/Jadwal::fetchjadwalsemua', ['filter' => 'akseslogin']);
$routes->post('/jadwal/fetchjadwaldivisi', 'backend/Jadwal::fetchjadwaldivisi', ['filter' => 'akseslogin']);
$routes->post('/backend/jadwal/fetchjadwaldivisi', 'backend/Jadwal::fetchjadwaldivisi', ['filter' => 'akseslogin']);
$routes->post('/jadwal/savejadwal', 'backend/Jadwal::savejadwal', ['filter' => 'akseslogin']);
$routes->post('/backend/jadwal/savejadwal', 'backend/Jadwal::savejadwal', ['filter' => 'akseslogin']);
$routes->post('/jadwal/editmodal', 'backend/Jadwal::editmodal', ['filter' => 'akseslogin']);
$routes->post('/backend/jadwal/editmodal', 'backend/Jadwal::editmodal', ['filter' => 'akseslogin']);
$routes->post('/jadwal/editjadwal', 'backend/Jadwal::editjadwal', ['filter' => 'akseslogin']);
$routes->post('/backend/jadwal/editjadwal', 'backend/Jadwal::editjadwal', ['filter' => 'akseslogin']);
$routes->delete('/jadwal/deletejadwal/(:num)', 'backend\Jadwal::deletejadwal/$1', ['filter' => 'akseslogin']);
$routes->delete('/backend/jadwal/deletejadwal/(:num)', 'backend\Jadwal::deletejadwal/$1', ['filter' => 'akseslogin']);

$routes->get('/biaya', 'backend/Biaya::index', ['filter' => 'akseslogin']);
$routes->get('/backend/biaya', 'backend/Biaya::index', ['filter' => 'akseslogin']);
$routes->post('/biaya/fetchbiaya', 'backend/Biaya::fetchbiaya', ['filter' => 'akseslogin']);
$routes->post('/backend/biaya/fetchbiaya', 'backend/Biaya::fetchbiaya', ['filter' => 'akseslogin']);
$routes->post('/biaya/tambahbiaya', 'backend/Biaya::tambahbiaya', ['filter' => 'akseslogin']);
$routes->post('/backend/biaya/tambahbiaya', 'backend/Biaya::tambahbiaya', ['filter' => 'akseslogin']);
$routes->post('/biaya/editbiayamodal', 'backend/Biaya::editbiayamodal', ['filter' => 'akseslogin']);
$routes->post('/backend/biaya/editbiayamodal', 'backend/Biaya::editbiayamodal', ['filter' => 'akseslogin']);
$routes->post('/biaya/editbiaya', 'backend/Biaya::editbiaya', ['filter' => 'akseslogin']);
$routes->post('/backend/biaya/editbiaya', 'backend/Biaya::editbiaya', ['filter' => 'akseslogin']);
$routes->delete('/biaya/deletebiaya/(:num)', 'backend\Biaya::deletebiaya/$1', ['filter' => 'akseslogin']);
$routes->delete('/backend/biaya/deletebiaya/(:num)', 'backend\Biaya::deletebiaya/$1', ['filter' => 'akseslogin']);

/**
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
  require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
