<?php

namespace UltimatePostKit\Modules\SkideSlider\Widgets;

use  Elementor\Controls_Manager ;
use  Elementor\Group_Control_Border ;
use  Elementor\Group_Control_Box_Shadow ;
use  Elementor\Group_Control_Typography ;
use  Elementor\Group_Control_Text_Shadow ;
use  Elementor\Group_Control_Image_Size ;
use  Elementor\Group_Control_Background ;
use  UltimatePostKit\Utils ;
use  UltimatePostKit\Traits\Global_Widget_Controls ;
use  UltimatePostKit\Includes\Controls\GroupQuery\Group_Control_Query ;
use  WP_Query ;
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly
class Skide_Slider extends Group_Control_Query
{
    use  Global_Widget_Controls ;
    private  $_query = null ;
    public function get_name()
    {
        return 'upk-skide-slider';
    }
    
    public function get_title()
    {
        return BDTUPK . esc_html__( 'Skide Slider', 'ultimate-post-kit' );
    }
    
    public function get_icon()
    {
        return 'upk-widget-icon upk-icon-skide-slider';
    }
    
    public function get_categories()
    {
        return [ 'ultimate-post-kit' ];
    }
    
    public function get_keywords()
    {
        return [
            'post',
            'carousel',
            'blog',
            'recent',
            'news',
            'slider',
            'skide'
        ];
    }
    
    public function get_style_depends()
    {
        
        if ( $this->upk_is_edit_mode() ) {
            return [ 'upk-all-styles' ];
        } else {
            return [ 'ultimate-post-kit-font', 'upk-skide-slider' ];
        }
    
    }
    
    public function get_script_depends()
    {
        
        if ( $this->upk_is_edit_mode() ) {
            return [ 'upk-all-scripts' ];
        } else {
            return [ 'upk-skide-slider' ];
        }
    
    }
    
    // public function get_custom_help_url() {
    // 	return 'https://youtu.be/2ZYnLz__uA4';
    // }
    public function get_query()
    {
        return $this->_query;
    }
    
    protected function register_controls()
    {
        $this->start_controls_section( 'section_content_layout', [
            'label' => esc_html__( 'Layout', 'ultimate-post-kit' ),
        ] );
        $this->add_responsive_control( 'item_height', [
            'label'      => esc_html__( 'Height', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::SLIDER,
            'size_units' => [ 'px', 'vh' ],
            'range'      => [
            'px' => [
            'min' => 200,
            'max' => 1080,
        ],
            'vh' => [
            'min' => 10,
            'max' => 100,
        ],
        ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-skide-item' => 'height: {{SIZE}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'content_max_width', [
            'label'      => esc_html__( 'Content Max Width', 'bdthemes-prime-slider' ),
            'type'       => Controls_Manager::SLIDER,
            'size_units' => [ 'px', 'vw', '%' ],
            'range'      => [
            'px' => [
            'min' => 200,
            'max' => 1080,
        ],
            'vw' => [
            'min' => 10,
            'max' => 100,
        ],
            '%'  => [
            'min' => 10,
            'max' => 100,
        ],
        ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-content' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'content_alignment', [
            'label'     => __( 'Alignment', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::CHOOSE,
            'options'   => [
            'left'   => [
            'title' => __( 'Left', 'ultimate-post-kit' ),
            'icon'  => 'eicon-h-align-left',
        ],
            'center' => [
            'title' => __( 'Center', 'ultimate-post-kit' ),
            'icon'  => 'eicon-h-align-center',
        ],
            'right'  => [
            'title' => __( 'Right', 'ultimate-post-kit' ),
            'icon'  => 'eicon-h-align-right',
        ],
        ],
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-content' => 'text-align: {{VALUE}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Image_Size::get_type(), [
            'name'    => 'primary_thumbnail',
            'exclude' => [ 'custom' ],
            'default' => 'full',
        ] );
        $this->add_control( 'hr_1', [
            'type' => Controls_Manager::DIVIDER,
        ] );
        //Global Title Controls
        $this->register_title_controls();
        $this->add_control( 'show_category', [
            'label'   => esc_html__( 'Show Category', 'ultimate-post-kit' ),
            'type'    => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ] );
        $this->add_control( 'show_author', [
            'label'     => esc_html__( 'Show Author', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::SWITCHER,
            'default'   => 'yes',
            'separator' => 'before',
        ] );
        $this->add_control( 'meta_separator', [
            'label'       => __( 'Separator', 'ultimate-post-kit' ),
            'type'        => Controls_Manager::TEXT,
            'default'     => '//',
            'label_block' => false,
        ] );
        //Global Date Controls
        $this->register_date_controls();
        $this->add_control( 'show_comments', [
            'label'     => esc_html__( 'Show Comments', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::SWITCHER,
            'default'   => 'yes',
            'separator' => 'before',
        ] );
        $this->add_control( 'show_top_stories', [
            'label'     => esc_html__( 'Show Top Stories', 'ultimate-post-kit' ) . BDTUPK_PC,
            'type'      => Controls_Manager::SWITCHER,
            'separator' => 'before',
            'classes'   => BDTUPK_IS_PC,
        ] );
        $this->end_controls_section();
        // Query Settings
        $this->start_controls_section( 'section_post_query_builder', [
            'label' => __( 'Query', 'ultimate-post-kit' ),
            'tab'   => Controls_Manager::TAB_CONTENT,
        ] );
        $this->add_control( 'item_limit', [
            'label'   => esc_html__( 'Item Limit', 'ultimate-post-kit' ),
            'type'    => Controls_Manager::SLIDER,
            'range'   => [
            'px' => [
            'min' => 1,
            'max' => 20,
        ],
        ],
            'default' => [
            'size' => 12,
        ],
        ] );
        $this->register_query_builder_controls();
        $this->end_controls_section();
        $this->start_controls_section( 'section_carousel_settings', [
            'label' => __( 'Slider Settings', 'ultimate-post-kit' ),
        ] );
        $this->add_control( 'autoplay', [
            'label'   => __( 'Autoplay', 'ultimate-post-kit' ),
            'type'    => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ] );
        $this->add_control( 'autoplay_speed', [
            'label'     => esc_html__( 'Autoplay Speed', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::NUMBER,
            'default'   => 5000,
            'condition' => [
            'autoplay' => 'yes',
        ],
        ] );
        $this->add_control( 'pauseonhover', [
            'label' => esc_html__( 'Pause on Hover', 'ultimate-post-kit' ),
            'type'  => Controls_Manager::SWITCHER,
        ] );
        $this->add_control( 'grab_cursor', [
            'label' => __( 'Grab Cursor', 'ultimate-post-kit' ),
            'type'  => Controls_Manager::SWITCHER,
        ] );
        $this->add_control( 'loop', [
            'label'   => __( 'Loop', 'ultimate-post-kit' ),
            'type'    => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ] );
        $this->add_control( 'speed', [
            'label'   => __( 'Animation Speed (ms)', 'ultimate-post-kit' ),
            'type'    => Controls_Manager::SLIDER,
            'default' => [
            'size' => 500,
        ],
            'range'   => [
            'px' => [
            'min'  => 100,
            'max'  => 5000,
            'step' => 50,
        ],
        ],
        ] );
        $this->add_control( 'observer', [
            'label'       => __( 'Observer', 'ultimate-post-kit' ),
            'description' => __( 'When you use carousel in any hidden place (in tabs, accordion etc) keep it yes.', 'ultimate-post-kit' ),
            'type'        => Controls_Manager::SWITCHER,
        ] );
        $this->end_controls_section();
        //Style
        $this->start_controls_section( 'upk_section_style', [
            'label' => esc_html__( 'Items', 'ultimate-post-kit' ),
            'tab'   => Controls_Manager::TAB_STYLE,
        ] );
        $this->add_responsive_control( 'item_padding', [
            'label'      => __( 'Padding', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'item_margin', [
            'label'      => __( 'Margin', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_style_title', [
            'label'     => esc_html__( 'Title', 'ultimate-post-kit' ),
            'tab'       => Controls_Manager::TAB_STYLE,
            'condition' => [
            'show_title' => 'yes',
        ],
        ] );
        $this->add_control( 'title_color', [
            'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-title a' => 'color: {{VALUE}};',
        ],
        ] );
        $this->add_control( 'title_hover_color', [
            'label'     => esc_html__( 'Hover Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-title a:hover' => 'color: {{VALUE}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Background::get_type(), [
            'name'     => 'title_background',
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-title a',
        ] );
        $this->add_responsive_control( 'title_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-title a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'title_padding', [
            'label'      => __( 'Padding', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'title_spacing', [
            'label'     => esc_html__( 'Spacing', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::SLIDER,
            'range'     => [
            'px' => [
            'min' => 0,
            'max' => 100,
        ],
        ],
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Typography::get_type(), [
            'name'     => 'title_typography',
            'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-title',
        ] );
        $this->add_group_control( Group_Control_Text_Shadow::get_type(), [
            'name'     => 'title_text_shadow',
            'label'    => __( 'Text Shadow', 'ultimate-post-kit' ),
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-title a',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_style_meta', [
            'label'      => esc_html__( 'Meta', 'ultimate-post-kit' ),
            'tab'        => Controls_Manager::TAB_STYLE,
            'conditions' => [
            'relation' => 'or',
            'terms'    => [ [
            'name'  => 'show_author',
            'value' => 'yes',
        ], [
            'name'  => 'show_date',
            'value' => 'yes',
        ], [
            'name'  => 'show_comments',
            'value' => 'yes',
        ] ],
        ],
        ] );
        $this->add_control( 'meta_color', [
            'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-meta .upk-date-comments, {{WRAPPER}} .upk-skide-slider .upk-meta .upk-author-name a' => 'color: {{VALUE}};',
        ],
        ] );
        $this->add_control( 'meta_hover_color', [
            'label'     => esc_html__( 'Hover Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-meta .upk-author-name a:hover' => 'color: {{VALUE}};',
        ],
        ] );
        $this->add_responsive_control( 'meta_space_between', [
            'label'     => esc_html__( 'Space Between', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::SLIDER,
            'range'     => [
            'px' => [
            'min' => 0,
            'max' => 50,
        ],
        ],
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-meta .upk-separator' => 'margin: 0 {{SIZE}}{{UNIT}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Typography::get_type(), [
            'name'     => 'meta_author_typography',
            'label'    => esc_html__( 'Author Typography', 'ultimate-post-kit' ),
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-meta .upk-author-name a',
        ] );
        $this->add_group_control( Group_Control_Typography::get_type(), [
            'name'     => 'meta_date_typography',
            'label'    => esc_html__( 'Date/Comments Typography', 'ultimate-post-kit' ),
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-meta .upk-date-comments',
        ] );
        $this->end_controls_section();
        $this->start_controls_section( 'section_style_category', [
            'label'     => esc_html__( 'Category', 'ultimate-post-kit' ),
            'tab'       => Controls_Manager::TAB_STYLE,
            'condition' => [
            'show_category' => 'yes',
        ],
        ] );
        $this->add_responsive_control( 'category_bottom_spacing', [
            'label'     => esc_html__( 'Spacing', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::SLIDER,
            'range'     => [
            'px' => [
            'min' => 0,
            'max' => 50,
        ],
        ],
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-category' => 'margin-bottom: {{SIZE}}{{UNIT}};',
        ],
        ] );
        $this->start_controls_tabs( 'tabs_category_style' );
        $this->start_controls_tab( 'tab_category_normal', [
            'label' => esc_html__( 'Normal', 'ultimate-post-kit' ),
        ] );
        $this->add_control( 'category_color', [
            'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-category a' => 'color: {{VALUE}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Background::get_type(), [
            'name'     => 'category_background',
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-category a',
        ] );
        $this->add_group_control( Group_Control_Border::get_type(), [
            'name'     => 'category_border',
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-category a',
        ] );
        $this->add_responsive_control( 'category_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-category a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'category_padding', [
            'label'      => esc_html__( 'Padding', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-slider .upk-category a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'category_spacing', [
            'label'     => esc_html__( 'Space Between', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::SLIDER,
            'range'     => [
            'px' => [
            'min' => 0,
            'max' => 50,
        ],
        ],
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-category a+a' => 'margin-left: {{SIZE}}{{UNIT}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Box_Shadow::get_type(), [
            'name'     => 'category_shadow',
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-category a',
        ] );
        $this->add_group_control( Group_Control_Typography::get_type(), [
            'name'     => 'category_typography',
            'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-category a',
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_category_hover', [
            'label'     => esc_html__( 'Hover', 'ultimate-post-kit' ),
            'condition' => [
            'show_category' => 'yes',
        ],
        ] );
        $this->add_control( 'category_hover_color', [
            'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-category a:hover' => 'color: {{VALUE}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Background::get_type(), [
            'name'     => 'category_hover_background',
            'selector' => '{{WRAPPER}} .upk-skide-slider .upk-category a:hover',
        ] );
        $this->add_control( 'category_hover_border_color', [
            'label'     => esc_html__( 'Border Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'condition' => [
            'category_border_border!' => '',
        ],
            'selectors' => [
            '{{WRAPPER}} .upk-skide-slider .upk-category a:hover' => 'border-color: {{VALUE}};',
        ],
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section( 'section_style_thumbs', [
            'label' => esc_html__( 'Thumbs', 'ultimate-post-kit' ),
            'tab'   => Controls_Manager::TAB_STYLE,
        ] );
        $this->start_controls_tabs( 'tabs_thumbs_style' );
        $this->start_controls_tab( 'tab_thumbs_image', [
            'label' => esc_html__( 'Image', 'ultimate-post-kit' ),
        ] );
        $this->add_group_control( Group_Control_Border::get_type(), [
            'name'     => 'thumbs_image_border',
            'selector' => '{{WRAPPER}} .upk-skide-thumbs .upk-thumbs-img .upk-img',
        ] );
        $this->add_responsive_control( 'thumbs_image_border_radius', [
            'label'      => esc_html__( 'Border Radius', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-thumbs .upk-thumbs-img .upk-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->add_responsive_control( 'thumbs_img_margin', [
            'label'      => __( 'Margin', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-thumbs .upk-thumbs-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->end_controls_tab();
        $this->start_controls_tab( 'tab_thumbs_title', [
            'label' => esc_html__( 'Title', 'ultimate-post-kit' ),
        ] );
        $this->add_control( 'thumbs_title_color', [
            'label'     => esc_html__( 'Color', 'ultimate-post-kit' ),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
            '{{WRAPPER}} .upk-skide-thumbs .upk-title a' => 'color: {{VALUE}};',
        ],
        ] );
        $this->add_responsive_control( 'thumbs_title_margin', [
            'label'      => __( 'Margin', 'ultimate-post-kit' ),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors'  => [
            '{{WRAPPER}} .upk-skide-thumbs .upk-title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        ] );
        $this->add_group_control( Group_Control_Typography::get_type(), [
            'name'     => 'thumbs_title_typography',
            'label'    => esc_html__( 'Typography', 'ultimate-post-kit' ),
            'selector' => '{{WRAPPER}} .upk-skide-thumbs .upk-title',
        ] );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    
    /**
     * Main query render for this widget
     * @param $posts_per_page number item query limit
     */
    public function query_posts( $posts_per_page )
    {
        $default = $this->getGroupControlQueryArgs();
        
        if ( $posts_per_page ) {
            $args['posts_per_page'] = $posts_per_page;
            $args['paged'] = max( 1, get_query_var( 'paged' ), get_query_var( 'page' ) );
        }
        
        $args = array_merge( $default, $args );
        $this->_query = new WP_Query( $args );
    }
    
    public function render_image( $image_id, $size )
    {
        $placeholder_image_src = Utils::get_placeholder_image_src();
        $image_src = wp_get_attachment_image_src( $image_id, $size );
        
        if ( !$image_src ) {
            $image_src = $placeholder_image_src;
        } else {
            $image_src = $image_src[0];
        }
        
        ?>

		<img class="upk-img swiper-lazy" src="<?php 
        echo  esc_url( $image_src ) ;
        ?>" alt="<?php 
        echo  esc_attr( get_the_title() ) ;
        ?>">

	<?php 
    }
    
    public function render_title()
    {
        $settings = $this->get_settings_for_display();
        if ( !$this->get_settings( 'show_title' ) ) {
            return;
        }
        printf(
            '<%1$s class="upk-title"><a href="%2$s" title="%3$s">%3$s</a></%1$s>',
            Utils::get_valid_html_tag( $settings['title_tags'] ),
            get_permalink(),
            get_the_title()
        );
    }
    
    public function render_excerpt( $excerpt_length )
    {
        if ( !$this->get_settings( 'show_excerpt' ) ) {
            return;
        }
        $strip_shortcode = $this->get_settings_for_display( 'strip_shortcode' );
        ?>
		<div class="upk-skide-desc" data-swiper-parallax-y="-80" data-swiper-parallax-duration="900">
			<?php 
        
        if ( has_excerpt() ) {
            the_excerpt();
        } else {
            echo  ultimate_post_kit_custom_excerpt( $excerpt_length, $strip_shortcode ) ;
        }
        
        ?>
		</div>

	<?php 
    }
    
    public function render_category()
    {
        if ( !$this->get_settings( 'show_category' ) ) {
            return;
        }
        ?>
		<div class="upk-category" data-swiper-parallax="-300">
			<?php 
        echo  get_the_category_list( ' ' ) ;
        ?>
		</div>
	<?php 
    }
    
    public function render_date()
    {
        $settings = $this->get_settings_for_display();
        if ( !$this->get_settings( 'show_date' ) ) {
            return;
        }
        ?>
		<div class="upk-date upk-flex upk-flex-middle">
			<div class="upk-date">
				<?php 
        
        if ( $settings['human_diff_time'] == 'yes' ) {
            echo  ultimate_post_kit_post_time_diff( ( $settings['human_diff_time_short'] == 'yes' ? 'short' : '' ) ) ;
        } else {
            echo  get_the_date() ;
        }
        
        ?>
			</div>
			<?php 
        
        if ( $settings['show_time'] ) {
            ?>
				<div class="upk-post-time">
					<i class="upk-icon-clock" aria-hidden="true"></i>
					<?php 
            echo  get_the_time() ;
            ?>
				</div>
			<?php 
        }
        
        ?>
		</div>

	<?php 
    }
    
    public function render_author()
    {
        if ( !$this->get_settings( 'show_author' ) ) {
            return;
        }
        ?>
		<div class="upk-author-wrap">
			<span class="upk-by"><?php 
        echo  esc_html_x( 'by', 'Frontend', 'ultimate-post-kit' ) ;
        ?></span>
			<a class="upk-name" href="<?php 
        echo  get_author_posts_url( get_the_author_meta( 'ID' ) ) ;
        ?>">
				<?php 
        echo  get_the_author() ;
        ?>
			</a>
		</div>
	<?php 
    }
    
    public function render_comments( $id = 0 )
    {
        if ( !$this->get_settings( 'show_comments' ) ) {
            return;
        }
        ?>

		<div class="upk-comments">
			<?php 
        echo  get_comments_number( $id ) ;
        ?>
			<?php 
        echo  esc_html__( 'Comments', 'ultimate-post-kit' ) ;
        ?>
		</div>

	<?php 
    }
    
    public function render_header()
    {
        $id = 'upk-skide-slider-' . $this->get_id();
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute( 'skide-slider', 'id', $id );
        $this->add_render_attribute( 'skide-slider', 'class', [ 'upk-skide-slider' ] );
        $this->add_render_attribute( [
            'skide-slider' => [
            'data-settings' => [ wp_json_encode( array_filter( [
            "autoplay"       => ( "yes" == $settings["autoplay"] ? [
            "delay" => $settings["autoplay_speed"],
        ] : false ),
            "loop"           => ( $settings["loop"] == "yes" ? true : false ),
            "speed"          => $settings["speed"]["size"],
            "effect"         => 'fade',
            "fadeEffect"     => [
            'crossFade' => true,
        ],
            "lazy"           => true,
            "parallax"       => true,
            "grabCursor"     => ( $settings["grab_cursor"] === "yes" ? true : false ),
            "pauseOnHover"   => ( "yes" == $settings["pauseonhover"] ? true : false ),
            "slidesPerView"  => 1,
            "observer"       => ( $settings["observer"] ? true : false ),
            "observeParents" => ( $settings["observer"] ? true : false ),
            "loopedSlides"   => 4,
            "lazy"           => [
            "loadPrevNext" => "true",
        ],
        ] ) ) ],
        ],
        ] );
        ?>
		<div <?php 
        $this->print_render_attribute_string( 'skide-slider' );
        ?>>
			<div class="swiper-container">
				<div class="swiper-wrapper">
				<?php 
    }
    
    public function render_footer()
    {
        $settings = $this->get_settings_for_display();
        ?>

				</div>
			</div>
		</div>

	<?php 
    }
    
    public function render_post_grid_item( $post_id, $image_size )
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute(
            'slider-item',
            'class',
            'upk-skide-item swiper-slide',
            true
        );
        ?>
		<div <?php 
        $this->print_render_attribute_string( 'slider-item' );
        ?>>
			<div class="upk-image-wrap">
				<?php 
        $this->render_image( get_post_thumbnail_id( $post_id ), $image_size );
        ?>
			</div>
			<div class="upk-content">

				<?php 
        $this->render_category();
        ?>

				<?php 
        
        if ( $settings['show_title'] ) {
            ?>
					<div data-swiper-parallax="-200">
						<?php 
            $this->render_title();
            ?>
					</div>
				<?php 
        }
        
        ?>

				<div class="upk-meta" data-swiper-parallax="-100">
					<div class="upk-author-img">
						<?php 
        echo  get_avatar( get_the_author_meta( 'ID' ), 48 ) ;
        ?>
					</div>
					<div class="upk-meta-info">
						<div class="upk-author-name">
							<a href="<?php 
        echo  get_author_posts_url( get_the_author_meta( 'ID' ) ) ;
        ?>">
								<?php 
        echo  get_the_author() ;
        ?>
							</a>
						</div>
						<div class="upk-date-comments">
							<?php 
        $this->render_date();
        ?>
							<span class="upk-separator"><?php 
        echo  esc_html( $settings['meta_separator'] ) ;
        ?></span>
							<?php 
        $this->render_comments( $post_id );
        ?>
						</div>
					</div>
				</div>

			</div>
		</div>
	<?php 
    }
    
    public function render_thumbnav( $post_id, $image_size )
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute(
            'thumb-item',
            'class',
            'upk-skide-thumb-item swiper-slide',
            true
        );
        ?>
		<div <?php 
        $this->print_render_attribute_string( 'thumb-item' );
        ?>>
			<div class="upk-thumbs-img">
				<?php 
        $this->render_image( get_post_thumbnail_id( $post_id ), $image_size );
        ?>
			</div>
			<div class="upk-thumbs-content">
				<h3 class="upk-title">
					<a href="javascript:void(0);"><?php 
        echo  esc_html( get_the_title() ) ;
        ?></a>
				</h3>
			</div>
		</div>
	<?php 
    }
    
    public function render_top_stories()
    {
        $settings = $this->get_settings_for_display();
        if ( !$this->get_settings( 'show_top_stories' ) ) {
            return;
        }
        ?>

		<div class="upk-skide-top-stories">
			<h3 class="upk-header-title"><?php 
        echo  esc_html_x( 'Top Stories', 'Frontend', 'ultimate-post-kit' ) ;
        ?></h3>
			<?php 
        $story_posts = get_posts( [
            'post_status'    => 'publish',
            'post_type'      => $this->get_settings( 'posts_source' ),
            'orderby'        => 'comment_count',
            'order'          => 'desc',
            'posts_per_page' => 3,
        ] );
        if ( count( $story_posts ) > 0 ) {
            foreach ( $story_posts as $posts ) {
                // var_dump($posts);
                ?>
					<div class="upk-stories-item">
						<div class="upk-stories-img">
							<?php 
                $placeholder_image_src = Utils::get_placeholder_image_src();
                $image_id = get_post_thumbnail_id( $posts->ID );
                $image_src = wp_get_attachment_image_src( $image_id, 'thumbnail' );
                
                if ( !$image_src ) {
                    $image_src = $placeholder_image_src;
                } else {
                    $image_src = $image_src[0];
                }
                
                ?>
							<img class="upk-img swiper-lazy" src="<?php 
                echo  esc_url( $image_src ) ;
                ?>" alt="<?php 
                echo  esc_html( $posts->post_title ) ;
                ?>">
						</div>
						<div class="upk-stories-content">
							<div class="upk-date upk-flex upk-flex-middle">
								<div>
									<?php 
                
                if ( $settings['human_diff_time'] == 'yes' ) {
                    echo  ultimate_post_kit_post_time_diff( ( $settings['human_diff_time_short'] == 'yes' ? 'short' : '' ) ) ;
                } else {
                    echo  get_the_date() ;
                }
                
                ?>
								</div>
								<?php 
                
                if ( $settings['show_time'] ) {
                    ?>
									<div class="upk-post-time">
										<i class="upk-icon-clock" aria-hidden="true"></i>
										<?php 
                    echo  get_the_time() ;
                    ?>
									</div>
								<?php 
                }
                
                ?>
							</div>
							<?php 
                printf( '<h3 class="upk-title"><a href="%2$s">%1$s</a></h3>', $posts->post_title, get_permalink() );
                ?>
						</div>
					</div>
			<?php 
            }
        }
        ?>

		</div>

	<?php 
    }
    
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $this->query_posts( $settings['item_limit']['size'] );
        $wp_query = $this->get_query();
        if ( !$wp_query->found_posts ) {
            return;
        }
        ?>
		<div class="upk-skide-slider-wrap">
			<?php 
        $this->render_header();
        while ( $wp_query->have_posts() ) {
            $wp_query->the_post();
            $thumbnail_size = $settings['primary_thumbnail_size'];
            $this->render_post_grid_item( get_the_ID(), $thumbnail_size );
        }
        $this->render_footer();
        ?>
			<div thumbsSlider="" class="swiper-container upk-skide-thumbs">
				<div class="swiper-wrapper">
					<?php 
        while ( $wp_query->have_posts() ) {
            $wp_query->the_post();
            $thumbnail_size = $settings['primary_thumbnail_size'];
            $this->render_thumbnav( get_the_ID(), $thumbnail_size );
        }
        ?>
				</div>
			</div>
			<?php 
        ?>

		</div>

<?php 
        wp_reset_postdata();
    }

}