<?= $this->extend('backend/layout/template_admin'); ?>


<?= $this->section('content'); ?>


<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
      <div class="breadcrumb-title pe-3">Admin</div>
      <div class="ps-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0 p-0">
            <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Admin</li>
          </ol>
        </nav>
      </div>

    </div>
    <!--end breadcrumb-->
    <h6 class="mb-0 text-uppercase">Admin <?= $setting['nama_sekolah']; ?></h6>
    <hr />

    <div class="row">
      <div class="col">
        <!-- Button trigger modal -->
        <button type="button" class="btn btn-primary" id="btntambahpetugasbaru" data-bs-toggle="modal" data-bs-target="#tambahpetugas">Tambah</button>
        <!-- Modal -->
        <div class="modal fade" id="tambahpetugas" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Tambah Petugas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <form method="post" action="" id="tambahpetugasform">
                  <?= csrf_field(); ?>
                  <div class="row mb-3">
                    <label for="username" class="col-sm-3 col-form-label">Username</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="username" name="username" placeholder="Masukkan Username">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="password" class="col-sm-3 col-form-label">Password</label>
                    <div class="col-sm-9">
                      <input type="password" class="form-control" id="password" name="password">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="repassword" class="col-sm-3 col-form-label">Re-Password</label>
                    <div class="col-sm-9">
                      <input type="password" class="form-control" id="repassword" name="repassword">
                    </div>
                  </div>
                  <div class="row mb-3">
                    <label for="nama" class="col-sm-3 col-form-label">Nama</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" id="nama" name="nama" placeholder="Masukkan Nama">
                    </div>
                  </div>



              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" id="btntambahpetugas" class="btn btn-primary">Simpan</button>
              </div>
              </form>
            </div>
          </div>
        </div>

        <!-- import -->
        <!-- <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#importpetugas">Import</button> -->
        <!-- Modal -->
        <!-- <div class="modal fade" id="importpetugas" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Import Petugas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <div class="card">
                  <div class="card-body">
                    <input id="fancy-file-upload" type="file" name="files" accept=".jpg, .png, image/jpeg, image/png" multiple>
                  </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Import</button>
              </div>
            </div>
          </div>
        </div> -->

        <!-- hapus -->
        <!-- <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#hapuspetugas">Hapus</button> -->

      </div>


    </div>



    <div class="card">
      <div class="card-body">
        <div class="table-responsive">
          <table id="tablePetugas" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr>
                <th>No</th>
                <th>Action</th>
                <th>Username</th>
                <th>Nama</th>
              </tr>
            </thead>
            <tbody>



            </tbody>
            <tfoot>
              <tr>
                <th>No</th>
                <th>Action</th>
                <th>Username</th>
                <th>Nama</th>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
    </div>

  </div>
</div>
<!--end page wrapper -->



</div>
<!--end wrapper-->

<!-- Modal Edit Password -->
<div class="modal fade" id="passwordModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="passwordModalLabel">Edit Password</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
        </button>
      </div>
      <div class="modal-body">
        <form method="post" action="" id="editpasswordform">
          <?= csrf_field(); ?>
          <input type="hidden" name="iduserpassword">
          <div class="row mb-3">
            <label for="Nama" class="col-sm-3 ">Nama</label>
            <div class="col-sm-9">
              <p id="namapassword"></p>
            </div>
          </div>
          <div class="row mb-3">
            <label for="password" class="col-sm-3 col-form-label">Password</label>
            <div class="col-sm-9">
              <input type="password" autocomplete="new password" class="form-control" id="editpassword" name="password" placeholder="Masukkan Password">
            </div>
          </div>
          <div class="row mb-3">
            <label for="confimrpassword" class="col-sm-3 col-form-label">Confirm Password</label>
            <div class="col-sm-9">
              <input type="password" autocomplete="Confirm password" class="form-control" id="editrepassword" name="repassword" placeholder="Confirm Password">
            </div>
          </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Modal Edit-->
<div class="modal fade" id="editpetugasModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit Admin</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post" action="" id="editpetugasform">
          <?= csrf_field(); ?>
          <input type="hidden" name="idpetugas">
          <input type="hidden" class="form-control" id="editusernamelama" name="usernamelama" placeholder="Username lama">
          <div class="row mb-3">
            <label for="username" class="col-sm-3 col-form-label">Username</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="editusername" name="username" placeholder="Masukkan Username">
            </div>
          </div>
          <div class="row mb-3">
            <label for="nama" class="col-sm-3 col-form-label">Nama</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="editnama" name="nama" placeholder="Masukkan Nama">
            </div>
          </div>


      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" id="btneditpetugas" class="btn btn-primary">Simpan</button>
      </div>
      </form>
    </div>
  </div>
</div>


<script>
  $('#fancy-file-upload').FancyFileUpload({
    params: {
      action: 'fileuploader'
    },
    maxfilesize: 1000000
  });
</script>

<script>
  $(document).ready(function() {

    $("#btntambahpetugasbaru").click(function() {
      $('#tambahpetugasform')[0].reset();
    });

    //fetch jabatan
    function fetchPetugas() {
      $.ajax({
        url: '<?= base_url(); ?>/user/fetchuser',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          $('#tablePetugas').DataTable({
            "data": data.user,
            "responsive": true,
            "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
              "<'row'<'col-sm-12'tr>>" +
              "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": [{
                extend: 'copyHtml5',
                text: '<i class="fadeIn animated bx bx-copy"></i>',
                titleAttr: 'Copy'
              },
              {
                extend: 'excelHtml5',
                text: 'excel',
                titleAttr: 'Excel',
              },
              {
                extend: 'csvHtml5',
                text: 'csv',
                titleAttr: 'Excel'
              },
              {
                extend: 'pdfHtml5',
                text: 'pdf',
                titleAttr: 'Pdf'
              },
              {
                extend: 'print',
                text: '<i class="lni lni-printer"></i>',
                titleAttr: 'Print'
              },
              {
                extend: 'colvis',
                text: '',
                titleAttr: 'Colvis'
              }
            ],

            "columns": [{
                "data": null,
                "render": function() {
                  return a = i++;
                }
              },
              {
                "data": null,
                "render": function(data, type, row, meta) {
                  let a = '';
                  a = `
                  <a href="" class="badge bg-warning text-dark gantipassword" value="${row.id}/${row.nama}"><i class="fadeIn animated bx bx-lock"></i></a>                  
                  <a href="" class="badge bg-info text-dark editpetugasdata" value="${row.id}"><i class="fadeIn animated bx bx-edit-alt"></i></a>
                  <a href="" class="deletepetugas badge bg-danger text-light" value="${row.id}"><i class="fadeIn animated bx bx-trash-alt"></i></a>`;


                  return a;
                }
              },

              {
                "data": "username"
              },
              {
                "data": "nama"
              }


            ]
          });
        }
      });
    }

    fetchPetugas();

    // save petugas
    $('#tambahpetugasform').submit(function() {
      event.preventDefault();

      $.ajax({
        url: '<?= base_url('/user/saveuser'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        // data: $(this).serialize(),
        beforeSend: function() {
          // setting a timeout
          $('#btntambahpetugas').attr('disabled');
          $("#btntambahpetugas").html(`<div class="spinner-border spinner-border-sm" role="status" aria-hidden="true"><span class="visually-hidden">Loading...</span></div>`);
        },
        success: function(data) {
          if (data.responce == "success") {
            $('#tambahpetugas').modal('hide');
            $('#tablePetugas').DataTable().destroy();
            fetchPetugas();
            toastr["success"](data.pesan);

          } else {
            // console.log(data);
            // alert(data.pesan);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btntambahpetugas').removeAttr('disabled');
          $("#btntambahpetugas").html(`Simpan`);

        },
      });
    });

    //ganti password
    $(document).on('click', '.gantipassword', function() {
      event.preventDefault();
      // alert("buka gantipassword");
      $("#editpasswordform")[0].reset();

      let arrayvalue = $(this).attr("value").split("/");

      let idpetugas = arrayvalue[0];
      let namapetugas = arrayvalue[1];


      // let idpetugas = $(this).attr("value");

      $('#passwordModal').modal('show')
      $("input[name='iduserpassword']").val(idpetugas);
      $("#namapassword").text(namapetugas);
    });

    // edit password
    $('#editpasswordform').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/user/editpassword'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        success: function(data) {
          if (data.responce == "success") {
            $('#passwordModal').modal('hide');
            toastr["success"](data.pesan);
          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        }
      })
    });

    // delete petugas
    $(document).on('click', '.deletepetugas', function() {
      event.preventDefault();
      // alert("mau delete");
      let idpetugas = $(this).attr('value');
      Swal.fire({
        title: 'Apa kamu yakin untuk menghapusnya?',
        text: "kamu tidak akan bisa mengembalikannya",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Ya, hapus saja!'
      }).then((result) => {
        if (result.value) {
          $.ajax({
            url: '<?= base_url('/user/deleteuser'); ?>/' + idpetugas,
            type: 'DELETE',
            error: function() {
              alert('Something is wrong');
            },
            success: function(data) {
              $('#tablePetugas').DataTable().destroy();
              fetchPetugas();
              Swal.fire(
                'Deleted!',
                'Admin sudah dihapus.',
                'success'
              )
            }
          });

        }
      })
    });

    // modal edit
    $(document).on('click', '.editpetugasdata', function() {
      event.preventDefault();
      // alert('You prevented a link from opening the URL');

      let idpetugas = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/user/editmodal'); ?>',
        type: 'post',
        data: {
          iduser: idpetugas
        },
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          if (data.responce == 'success') {
            $('#editpetugasModal').modal('show');

            $("input[name='idpetugas']").val(data.user.id);

            $("input[name='nama']").val(data.user.nama);
            $("input[name='username']").val(data.user.username);
            $("input[name='usernamelama']").val(data.user.username);




          } else {

            toastr["error"](data.pesan);
          }

        }
      });
    });

    // Edit petugas
    $("#editpetugasform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/user/edituser',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btneditpetugas').attr('disabled');
          $("#btneditpetugas").html(`<div class="spinner-border spinner-border-sm" role="status" aria-hidden="true"><span class="visually-hidden">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            // console.log(data.update);
            $('#tablePetugas').DataTable().destroy();
            fetchPetugas();
            $('#editpetugasModal').modal('hide');
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
            // console.log(data);
          }


        },
        complete: function() {
          $('#btneditpetugas').removeAttr('disabled');
          $("#btneditpetugas").html(`Update`);

        },
      });


    });

  });
</script>


<?= $this->endSection(); ?>