<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>



<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">


        <div class="row">

            <div class="col-md-12">


                <div class="row mb-2">
                    <div class="col-md-8">
                        <button type="button" id="btntambahalur" class="btn btn-primary" data-toggle="modal" data-target="#tambahAlurModal">
                            Tambah
                        </button>

                    </div>

                    <!-- Modal Tambah -->
                    <div class="modal fade" id="tambahAlurModal" tabindex="-1" aria-labelledby="tambahAlurModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="tambahAlurModalLabel">Tambah Alur PPDB MIJ</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="tambahalurform" enctype="multipart/form-data">
                                        <?= csrf_field(); ?>
                                        <div class="form-group row">
                                            <label for="alur" class="col-sm-2 col-form-label">Alur</label>
                                            <div class="col-sm-10">
                                                <!-- <input type="text" class="form-control" name="alur"> -->
                                                <input type="file" class="form-control custom-file-input" id="foto" name="foto" onchange="previewImg()">
                                                <label class="custom-file-label" for="foto"></label>
                                                <div class="col-sm-12">
                                                    <img src="" class="img-thumbnail img-preview">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="aktif" checked='checked'>
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Aktif?
                                                    </label>
                                                </div>
                                                <!-- <input type="text" class="form-control" name="aktif"> -->
                                            </div>
                                        </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnsimpan">Simpan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Modal Edit -->
                    <div class="modal fade" id="editAlurModal" tabindex="-1" aria-labelledby="editAlurModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editAlurModalLabel">Edit Alur PPDB MIJ</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="" id="editalurform">
                                        <?= csrf_field(); ?>
                                        <input type="hidden" name="idalur">

                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label">Sort</label>
                                            <div class="col-sm-10">
                                                <input type="text" class="form-control" name="sort">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="text" class="col-sm-2 col-form-label"></label>
                                            <div class="col-sm-10">
                                                <div class="form-check">
                                                    <input class="form-check-input editaktif" type="checkbox" name="aktif">
                                                    <label class="form-check-label" for="defaultCheck1">
                                                        Aktif?
                                                    </label>
                                                </div>
                                                <!-- <input type="text" class="form-control" name="aktif"> -->
                                            </div>
                                        </div>


                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary" id="btnedit">Update</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col">
                        <div class="table-responsive">
                            <table class="table table-striped table-condensed" id="tabelAlur">
                                <thead class="bg-success">
                                    <tr>
                                        <!-- <th><input type="checkbox" id='checkall'></th> -->
                                        <th scope="col">No</th>
                                        <th scope="col">Alur</th>
                                        <th scope="col">sort</th>
                                        <th scope="col">Aktif</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>

                <div class="overlay asal-divisi-overlay" style="display: none;">
                    <!-- <i class="fas fa-sync fa-spin"></i> -->
                    <div id='loading-img'></div>
                </div>



            </div>
        </div>



    </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->
<script>
    function previewImg() {
        let foto = document.querySelector('#foto');
        let fotoLabel = document.querySelector('.custom-file-label');
        let imgPreview = document.querySelector('.img-preview');

        fotoLabel.textContent = foto.files[0].name;

        let fileFoto = new FileReader();
        fileFoto.readAsDataURL(foto.files[0]);

        fileFoto.onload = function(e) {
            imgPreview.src = e.target.result;
        }
    }
</script>

<script>
    $(document).ready(function() {

        function tabelalur(dataks) {
            let i = 1;
            let base = '<?= base_url(); ?>'
            $('#tabelAlur').DataTable({
                "data": dataks,
                "responsive": true,
                "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                "buttons": [{
                    extend: 'excelHtml5',
                    text: '<i class="far fa-fw fa-file-excel"></i>',
                    titleAttr: 'Excel'
                }],
                "columnDefs": [{
                    "className": "text-center",
                    "targets": "_all"
                }],

                "columns": [

                    {
                        "data": null,
                        "render": function() {

                            return a = i++;
                        }
                    },

                    {
                        "data": "alur",
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `<img src="` + base + `/asset/images/alur/` + data + `"  alt="..." width=200>`

                            return a;
                        }
                    },
                    {
                        "data": "sort"
                    },
                    {
                        "data": "aktif",
                        "render": function(data, type, row, meta) {
                            let a = '';

                            if (data == 1) {
                                a = 'aktif'
                            } else {
                                a = 'Tidak aktif'
                            }


                            return a;
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row, meta) {
                            let a = '';
                            a = `
                                    
                                    <a href="" value="${row.id}" class="badge badge-info editalur"><i class="fas fa-fw fa-edit"></i></a>
                                    <a href="" value="${row.id}" class="badge badge-danger deletealur"><i class="fas fa-fw fa-trash"></i></a>

                                    `

                            return a;
                        }
                    },
                ]
            });
        }



        //fetch User semua
        function fetchAlur() {
            $('.asal-divisi-overlay').show();
            $.ajax({
                url: '<?= base_url(); ?>/setting/fetchalur',
                type: 'post',
                dataType: 'json',
                success: function(data) {
                    // console.log(data.pegawai);
                    // let i = 1;
                    tabelalur(data.alur)
                }
            });
            $('.asal-divisi-overlay').hide();
        }

        fetchAlur();

        $(document).on('click', '#btntambahalur', function() {
            $('#tambahalurform')[0].reset();
        })

        // tambah alur
        $("#tambahalurform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/setting/tambahalur',
                type: 'post',
                data: new FormData(this),
                dataType: 'json',
                cache: false,
                processData: false,
                contentType: false,
                beforeSend: function() {
                    // setting a timeout
                    $('#btnsimpan').attr('disabled');
                    $("#btnsimpan").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    if (data.responce == "success") {
                        $('#tambahAlurModal').modal('hide');
                        $('#tabelAlur').DataTable().clear();
                        $('#tabelAlur').DataTable().destroy();
                        fetchAlur();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                        // console.log(data);
                    }
                },
                complete: function() {
                    $('#btnsimpan').removeAttr('disabled');
                    $("#btnsimpan").html(`Simpan`);


                },
            });
        });

        // delete alur
        $(document).on("click", ".deletealur", function() {
            event.preventDefault();
            let idalur = $(this).attr('value');

            Swal.fire({
                title: 'Apa kamu yakin untuk menghapusnya?',
                text: "kamu tidak akan bisa mengembalikannya",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, hapus saja!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?= base_url('/setting/deletealur'); ?>/' + idalur,
                        type: 'DELETE',
                        error: function() {
                            alert('Something is wrong');
                        },
                        success: function(data) {
                            $('#tabelAlur').DataTable().clear();
                            $('#tabelAlur').DataTable().destroy();
                            fetchAlur();
                            Swal.fire(
                                'Deleted!',
                                'Alur sudah terdelete.',
                                'success'
                            )
                        }
                    });

                }
            })
        });

        // modal edit
        $(document).on("click", ".editalur", function() {
            event.preventDefault();

            let idalur = $(this).attr("value")
            $.ajax({
                url: '<?= base_url('/setting/editalurmodal'); ?>',
                type: 'post',
                data: {
                    idalur: idalur
                },
                dataType: 'json',
                success: function(data) {
                    if (data.responce == 'success') {
                        console.log(data.alur.aktif)
                        $('#editAlurModal').modal('show');
                        $("input[name='idalur']").val(data.alur.id);
                        $("input[name='sort']").val(data.alur.sort);


                        if (data.alur.aktif == 1) {
                            $("input[name='aktif']").attr("checked", "checked");
                        }

                    } else {

                        toastr["error"](data.pesan);
                    }

                }
            });
        });

        $("#editalurform").submit(function(event) {
            event.preventDefault();
            $.ajax({
                url: '<?= base_url(); ?>/setting/editalur',
                type: 'post',
                data: $(this).serialize(),
                dataType: 'json',
                beforeSend: function() {
                    // setting a timeout
                    $('#btnedit').attr('disabled');
                    $("#btnedit").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

                },
                success: function(data) {
                    // console.log(data);
                    if (data.responce == "success") {
                        $('#editAlurModal').modal('hide');
                        $('#tabelAlur').DataTable().destroy();
                        fetchAlur();
                        toastr["success"](data.pesan);
                    } else {
                        toastr["error"](data.pesan);
                    }

                },
                complete: function() {
                    $('#btnedit').removeAttr('disabled');
                    $("#btnedit").html(`Update`);
                },

            });
        })

    })
</script>

<?= $this->endSection(); ?>